#include <stdlib.h>

#include <stdio.h>

#include <omp.h>

#include <stdlib.h>

#include <math.h>

#include <time.h>

#include <sys/time.h>

enum NAS_EP_B_c_16646 { false, true };
typedef enum NAS_EP_B_c_16646 logical;
struct named_NAS_EP_B_c_16660
{
	double real;
	double imag;
};

typedef struct named_NAS_EP_B_c_16660 dcomplex;
double randlc(double * x, double a);
void vranlc(int n, double * x, double a, double y[]);
void timer_clear(int n);
void timer_start(int n);
void timer_stop(int n);
double timer_read(int n);
void print_results(char * name, char class, int n1, int n2, int n3, int niter, double t, double mops, char * optype, logical verified, char * npbversion, char * compiletime, char * cs1, char * cs2, char * cs3, char * cs4, char * cs5, char * cs6, char * cs7);
static double x[(2*(1<<16))];
static double q[10];


#include <omp.h>
#include <time.h>
#include <sys/time.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
#define RED  "\x1B[31m"
#define GRN  "\x1B[32m"
#define MAG  "\x1B[35m"
#define RESET "\x1B[0m"
//When Initial directive is defined the original code runs in order to save the variables and timers' values.
#define Initial
//Once the Experimental directive is defined, the Experimental section runs and the results before and after modification to this code section gets compared.
#define Experimental
#ifdef Experimental
#undef Initial
#endif //Experimental
#define closeEnough(a, b) (fabs((a - b)) < 0.001)? 1 : 0
//Due to the fact that normalized loop iteration numbers begin at 0, the default option is set to 0.
//By default, the input and output of the experimental section are saved to the file on the first execution.
//When the experimental section is iterated over, this option allows the user to save the input and output of the iteration of the choice to a file.
#define iterationNum 0

//Set the verbosity based on how detailed you want the results:
//The initial value of verbosity is set based on how it is set in the Cetus run
//#define verbosity 0 shows the results of the comparison of the variables,
//#define verbosity 1 shows the execution time of the experimental section, the result of the comparison, and the value of the variables,
//#define verbosity 2 shows the reading/writing state of variables.
#define verbosity 0

void read_var_from_file(char *varName,void* var, size_t sizeOfType, size_t numElements, FILE* fp){
	if(fread(var, sizeOfType, numElements, fp) != numElements) {
			if(feof(fp))
				printf("%sPremature end of file.%s\n",RED,RESET);
			else
				printf("%sFile read error of var %s %s\n",RED,varName,RESET);
	}else if(verbosity > 1) {
			printf("%sThe value of variable %s is read from the file.%s\n",GRN,varName,RESET);
	     }
}

void write_var_to_file(char *varName, void* var, size_t sizeOfType, size_t numElements, FILE* fp){
	if(fwrite(var, sizeOfType, numElements, fp) != numElements) {
			if(feof(fp))
				printf("%sPremature end of file.%s\n",RED,RESET);
			else
				printf("%sFile write error of var %s %s\n",RED,varName,RESET);
	}else if(verbosity > 1) {
			printf("%sThe value of variable %s is written to the file.%s\n",GRN,varName,RESET);
	     }
}

#ifdef Experimental
void compare_two_int_variables_in_binary_files(FILE *initialOutputStateFile,FILE *modifiedOutputStateFile, char *varName, size_t sizeOfType, size_t numElements,char *varType, int filePointer){
	size_t n1, n2; //to check how many elements are read
	int offset = 0; //reports where the difference is
	int *tmp1 = malloc(sizeof(int) * numElements);
	int *tmp2 = malloc(sizeof(int) * numElements);
	initialOutputStateFile=fopen(initialOutputStateFile,"rb");
	modifiedOutputStateFile=fopen(modifiedOutputStateFile,"rb");
	if(initialOutputStateFile == NULL){
			printf("%sError: Failed to open initialOutputStateFile.%s\n", RED, RESET);
			return;
	}
	if(modifiedOutputStateFile == NULL){
		printf("%sError: Failed to open modifiedOutputStateFile.%s\n", RED, RESET);
		return;
	}
	//sets the file pointer at the right position
	if(fseek(initialOutputStateFile, filePointer, SEEK_SET) != 0){
			printf("%sError: Failed to set the file pointer for initialOutputStateFile.%s\n", RED, RESET);
			return;
	}
	if(fseek(modifiedOutputStateFile, filePointer, SEEK_SET) != 0){
			printf("%sError: Failed to set the file pointer for modifiedOutputStateFile.%s\n", RED, RESET);
			return;
	}
	n1 = fread(tmp1, sizeOfType, numElements, initialOutputStateFile);
	if (n1 <numElements && ferror(initialOutputStateFile)) {
		   printf("%sError: Failed to read from initialOutputStateFile. %s\n ",RED,RESET );
	}else if(verbosity > 1) {printf("%sinitialOutputStateFile is read successfully.%s\n",GRN,RESET); }
		n2 = fread(tmp2, sizeOfType, numElements, modifiedOutputStateFile);
		if (n2 <numElements && ferror(modifiedOutputStateFile)) {
			   printf("%sError: Failed to read from modifiedOutputStateFile.%s\n",RED,RESET);
		}else if(verbosity > 1) {printf("%smodifiedOutputStateFile is read successfully.%s\n",GRN,RESET); }
			// Check for possible buffer overflows when copying data from tmp1 and tmp2.
			size_t n_min = n1 < n2 ? n1 : n2;
			int ret= memcmp(tmp1, tmp2, sizeOfType * numElements);
			if(ret != 0) {
				   for (size_t i = 0; i < n_min; i++) {
					     if (tmp1[i] != tmp2[i]) {
						      offset = i;
							  if (n_min==1){
						         printf("%sMISMATCH: The value of variable %s before and after modification differs.%s\n", MAG, varName , RESET);}
						 	  else{
						          printf("%sMISMATCH: The value of variable %s before and after modification differs starting from element %d.%s\n",MAG,varName,offset, RESET);}
								   break;
						   }}
				}else if(ret==0){
					   printf("%sMATCH: The value of variable %s before and after modification is equal.%s\n",GRN,varName,RESET);
				}
				free(tmp1);
				free(tmp2);
				return;
			}

			void compare_two_double_variables_in_binary_files(FILE *initialOutputStateFile,FILE *modifiedOutputStateFile, char *varName, size_t sizeOfType, size_t numElements,char *varType, int filePointer){
				size_t n1, n2; //to check how many elements are read
				int offset = 0; //reports where the difference is
				double *tmp1 = malloc(sizeof(double) * numElements); //size 8
				double *tmp2 = malloc(sizeof(double) * numElements); //size 8
				initialOutputStateFile=fopen(initialOutputStateFile,"rb");
				modifiedOutputStateFile=fopen(modifiedOutputStateFile,"rb");
				if(initialOutputStateFile == NULL){
						printf("%sError: Failed to open initialOutputStateFile.%s\n", RED, RESET);
						return;
				}
				if(modifiedOutputStateFile == NULL){
						printf("%sError: Failed to open modifiedOutputStateFile.%s\n", RED, RESET);
						return;
				}
				if(fseek(initialOutputStateFile, filePointer, SEEK_SET) != 0){
						printf("%sError: Failed to set the file pointer for initialOutputStateFile.%s\n", RED, RESET);
						return;
				}
				if(fseek(modifiedOutputStateFile, filePointer, SEEK_SET) != 0){
						printf("%sError: Failed to set the file pointer for modifiedOutputStateFile.%s\n", RED, RESET);
						return;
				}
				n1 = fread(tmp1, sizeOfType, numElements, initialOutputStateFile);
				if (n1 <numElements && ferror(initialOutputStateFile)) {
						printf("%sError: Failed to read from initialOutputStateFile. %s\n ",RED,RESET );
				}else if(verbosity > 1) {printf("%sinitialOutputStateFile is read successfully.%s\n",GRN,RESET); }
					n2 = fread(tmp2, sizeOfType, numElements, modifiedOutputStateFile);
					if (n2 <numElements && ferror(modifiedOutputStateFile)) {
							printf("%sError: Failed to read from modifiedOutputStateFile.%s\n",RED,RESET);
					}else if(verbosity > 1) {printf("%smodifiedOutputStateFile is read successfully.%s\n",GRN,RESET); }
						size_t n_min = n1 < n2 ? n1 : n2;
						int ret= memcmp(tmp1, tmp2, sizeOfType * numElements);
						if(ret != 0) {
								for (size_t i = 0; i < n_min; i++) {
										if (tmp1[i] != tmp2[i] && !closeEnough(tmp1[i],tmp2[i]) && !(isnan(tmp1[i]) && isnan(tmp2[i])) ) {
												offset = i;
												if (n_min==1){
													printf("%sMISMATCH: The value of variable %s before and after modification differs.%s\n", MAG, varName , RESET);}
												else if((isnan(tmp1[i]) && isnan(tmp2[i]))){
													continue;
												}
												else if(!closeEnough(tmp1[i],tmp2[i])){
														printf("%sMISMATCH: The value of variable %s before and after modification differs starting from element %d.%s\n",MAG,varName,offset, RESET);
													break;}
										}else if ((tmp1[i] == tmp2[i] && i==n_min-1) || (closeEnough(tmp1[i],tmp2[i]) && i==n_min-1)){
												printf("%sMATCH: The value of variable %s before and after modification is equal.%s\n",GRN,varName,RESET);
												break;
										}
								}
						}else if(ret==0){
								printf("%sMATCH: The value of variable %s before and after modification is equal.%s\n",GRN,varName,RESET);
						}
						free(tmp1);
						free(tmp2);
						return;
					}

					void compare_two_float_variables_in_binary_files(FILE *initialOutputStateFile,FILE *modifiedOutputStateFile, char *varName, size_t sizeOfType, size_t numElements,char *varType, int filePointer){
						size_t n1, n2; //to check how many elements are read
						int offset = 0; //reports where the difference is
						float *tmp1 = malloc(sizeof(float) * numElements); //size 4
						float *tmp2 = malloc(sizeof(float) * numElements); //size 4
						initialOutputStateFile=fopen(initialOutputStateFile,"rb");
						modifiedOutputStateFile=fopen(modifiedOutputStateFile,"rb");
						if(initialOutputStateFile == NULL){
								printf("%sError: Failed to open initialOutputStateFile.%s\n", RED, RESET);
								return;
						}
						if(modifiedOutputStateFile == NULL){
								printf("%sError: Failed to open modifiedOutputStateFile.%s\n", RED, RESET);
								return;
						}
						if(fseek(initialOutputStateFile, filePointer, SEEK_SET) != 0){
								printf("%sError: Failed to set the file pointer for initialOutputStateFile.%s\n", RED, RESET);
								return;
						}
						if(fseek(modifiedOutputStateFile, filePointer, SEEK_SET) != 0){
								printf("%sError: Failed to set the file pointer for modifiedOutputStateFile.%s\n", RED, RESET);
								return;
						}
						n1 = fread(tmp1, sizeOfType, numElements, initialOutputStateFile);
						if (n1 <numElements && ferror(initialOutputStateFile)) {
								printf("%sError: Failed to read from initialOutputStateFile. %s\n ",RED,RESET );
						}else if(verbosity > 1) {printf("%sinitialOutputStateFile is read successfully.%s\n",GRN,RESET); }
							n2 = fread(tmp2, sizeOfType, numElements, modifiedOutputStateFile);
							if (n2 <numElements && ferror(modifiedOutputStateFile)) {
									printf("%sError: Failed to read from modifiedOutputStateFile.%s\n",RED,RESET);
							}else if(verbosity > 1) {printf("%smodifiedOutputStateFile is read successfully.%s\n",GRN,RESET); }
								size_t n_min = n1 < n2 ? n1 : n2;
								int ret= memcmp(tmp1, tmp2, sizeOfType * numElements);
								if(ret != 0) {
										for (size_t i = 0; i < n_min; i++) {
												if (tmp1[i] != tmp2[i] && !closeEnough(tmp1[i],tmp2[i]) && !(isnan(tmp1[i]) && isnan(tmp2[i])) ) {
														offset = i;
														if (n_min==1){
															printf("%sMISMATCH: The value of variable %s before and after modification differs.%s\n", MAG, varName , RESET);}
														else if((isnan(tmp1[i]) && isnan(tmp2[i]))){
															continue;
														}
														else if(!closeEnough(tmp1[i],tmp2[i])){
																printf("%sMISMATCH: The value of variable %s before and after modification differs starting from element %d.%s\n",MAG,varName,offset, RESET);
															break;}
												}else if ((tmp1[i] == tmp2[i] && i==n_min-1) || (closeEnough(tmp1[i],tmp2[i]) && i==n_min-1)){
														printf("%sMATCH: The value of variable %s before and after modification is equal.%s\n",GRN,varName,RESET);
											           break;
												}
										}
								}else if(ret==0){
										printf("%sMATCH: The value of variable %s before and after modification is equal.%s\n",GRN,varName,RESET);
								}
								free(tmp1);
								free(tmp2);
								return;
							}
							#endif // Experimental

							struct timeval startexp, endexp;
							double exp_time_used;
							double saved_exp_time_used;
							struct timeval prgstart, prgend;
							double prg_time_used;
							struct timeval captureStartInputWrite, captureEndInputWrite;
							double capture_input_write_time;
							struct timeval captureStartOutputWrite, captureEndOutputWrite;
							double capture_output_write_time;
							struct timeval replayStartInputRead, replayEndInputRead;
							double replay_input_read_time;
							struct timeval replayStartOutputWriteCompare, replayEndOutputWriteCompare;
							double replay_output_write_time;
							int iteration_count =0; //Counts the number of iterations the experimental section goes through.
							int _ret_val_0;

							FILE* initialInputStateFile;
							FILE* initialOutputStateFile;
							FILE* modifiedOutputStateFile;

							int main()
							{
								double Mops, t1, t2, t3, t4, x1, x2;
								double sx, sy, tm, an, tt, gc;
								double sx_verify_value, sy_verify_value, sx_err, sy_err;
								int np;
								int i, ik, kk, l, k, nit;
								int k_offset, j;
								logical verified, timers_enabled;
							double dum[3] = {1.0, 1.0, 1.0};
								char size[16];
								FILE * fp;
								int _ret_val_0;

								omp_set_num_threads(4);
								gettimeofday(&prgstart, NULL);

								#ifdef Initial

								if ((fp=fopen("timer.flag", "r"))==((void * )0))
								{
									timers_enabled=false;
								}
								else
								{
									timers_enabled=true;
									fclose(fp);
								}
								sprintf(size, "%15.0lf", pow(2.0, 30+1));
								j=14;
								if (size[j]=='.')
								{
									j -- ;
								}
								size[j+1]='\0';
								printf("\n\n NAS Parallel Benchmarks (NPB3.3-SER-C) - EP Benchmark\n");
								printf("\n Number of random numbers generated: %15s\n", size);
								verified=false;
								np=(1<<(30-16));
								vranlc(0,  & dum[0], dum[1],  & dum[2]);
								dum[0]=randlc( & dum[1], dum[2]);
								#pragma loop name main#0

								#pragma omp parallel for private(i)
								for (i=0; i<(2*(1<<16)); i ++ )
								{
									x[i]=( - 1.0E99);
								}
								Mops=log(sqrt(fabs(((1.0>1.0) ? 1.0 : 1.0))));
								timer_clear(0);
								timer_clear(1);
								timer_clear(2);
								timer_start(0);
								t1=1.220703125E9;
								vranlc(0,  & t1, 1.220703125E9, x);
								t1=1.220703125E9;
								#pragma loop name main#1

								for (i=0; i<(16+1); i ++ )
								{
									t2=randlc( & t1, t1);
								}
								an=t1;
								tt=2.71828183E8;
								gc=0.0;
								sx=0.0;
								sy=0.0;
								#pragma loop name main#2

								#pragma omp parallel for private(i)
								for (i=0; i<10; i ++ )
								{
									q[i]=0.0;
								}
								k_offset=( - 1);
								#pragma experimental section start In=double:an,int:i,int:ik,int:k,int:k_offset,int:kk,int:l,int:np,double:q:10,double:sx,double:sy,double:t1,double:t2,double:t3,double:t4,logical:timers_enabled,double:x:(2*(1<<16)),double:x1,double:x2,

								if (iteration_count==iterationNum) {
									gettimeofday(&captureStartInputWrite, NULL);
									initialInputStateFile= fopen("initialInputStateFile","wb");
									write_var_to_file("an",&an, sizeof(double), 1,initialInputStateFile );
									write_var_to_file("i",&i, sizeof(int), 1,initialInputStateFile );
									write_var_to_file("ik",&ik, sizeof(int), 1,initialInputStateFile );
									write_var_to_file("k",&k, sizeof(int), 1,initialInputStateFile );
									write_var_to_file("k_offset",&k_offset, sizeof(int), 1,initialInputStateFile );
									write_var_to_file("kk",&kk, sizeof(int), 1,initialInputStateFile );
									write_var_to_file("l",&l, sizeof(int), 1,initialInputStateFile );
									write_var_to_file("np",&np, sizeof(int), 1,initialInputStateFile );
									write_var_to_file("q",q, sizeof(double), 10,initialInputStateFile );
									write_var_to_file("sx",&sx, sizeof(double), 1,initialInputStateFile );
									write_var_to_file("sy",&sy, sizeof(double), 1,initialInputStateFile );
									write_var_to_file("t1",&t1, sizeof(double), 1,initialInputStateFile );
									write_var_to_file("t2",&t2, sizeof(double), 1,initialInputStateFile );
									write_var_to_file("t3",&t3, sizeof(double), 1,initialInputStateFile );
									write_var_to_file("t4",&t4, sizeof(double), 1,initialInputStateFile );
									write_var_to_file("timers_enabled",&timers_enabled, sizeof(logical), 1,initialInputStateFile );
									write_var_to_file("x",x, sizeof(double), (2*(1<<16)),initialInputStateFile );
									write_var_to_file("x1",&x1, sizeof(double), 1,initialInputStateFile );
									write_var_to_file("x2",&x2, sizeof(double), 1,initialInputStateFile );
									gettimeofday(&captureEndInputWrite, NULL);
									capture_input_write_time = (double) ((captureEndInputWrite.tv_sec * 1000000 + captureEndInputWrite.tv_usec) - (captureStartInputWrite.tv_sec * 1000000 + captureStartInputWrite.tv_usec)) / 1000000;
									if(verbosity > 0){
										printf("The input set of iteration %d is written to the file.\n",iteration_count);
										printf("The capture_input_write_time took %.6lf seconds.\n", capture_input_write_time);
									}
								}else{if(verbosity > 0){printf("The input set of iteration %d is not written to the file.\n",iteration_count);}}
									#endif //Initial

									#ifdef Experimental
									gettimeofday(&prgstart, NULL);
									double initial_exp_time_used;
									if(access("initialInputStateFile", F_OK) == 0){
										if(verbosity > 1) {printf("The file to load the initial state of variables exists.\n");}
											initialInputStateFile = fopen("initialInputStateFile", "rb");
									}else{
											printf("The file to load variables' initial states doesn't exist. Comment out #define Experimental and run the original Cetus output file.\n");
											exit(0);
									}
									gettimeofday(&replayStartInputRead, NULL);
									/* Seek to the beginning of the file */
									fseek(initialInputStateFile, 0, SEEK_SET);
									read_var_from_file("an",&an, sizeof(double), 1,initialInputStateFile );
									read_var_from_file("i",&i, sizeof(int), 1,initialInputStateFile );
									read_var_from_file("ik",&ik, sizeof(int), 1,initialInputStateFile );
									read_var_from_file("k",&k, sizeof(int), 1,initialInputStateFile );
									read_var_from_file("k_offset",&k_offset, sizeof(int), 1,initialInputStateFile );
									read_var_from_file("kk",&kk, sizeof(int), 1,initialInputStateFile );
									read_var_from_file("l",&l, sizeof(int), 1,initialInputStateFile );
									read_var_from_file("np",&np, sizeof(int), 1,initialInputStateFile );
									read_var_from_file("q",q, sizeof(double), 10,initialInputStateFile );
									read_var_from_file("sx",&sx, sizeof(double), 1,initialInputStateFile );
									read_var_from_file("sy",&sy, sizeof(double), 1,initialInputStateFile );
									read_var_from_file("t1",&t1, sizeof(double), 1,initialInputStateFile );
									read_var_from_file("t2",&t2, sizeof(double), 1,initialInputStateFile );
									read_var_from_file("t3",&t3, sizeof(double), 1,initialInputStateFile );
									read_var_from_file("t4",&t4, sizeof(double), 1,initialInputStateFile );
									read_var_from_file("timers_enabled",&timers_enabled, sizeof(logical), 1,initialInputStateFile );
									read_var_from_file("x",x, sizeof(double), (2*(1<<16)),initialInputStateFile );
									read_var_from_file("x1",&x1, sizeof(double), 1,initialInputStateFile );
									read_var_from_file("x2",&x2, sizeof(double), 1,initialInputStateFile );
									gettimeofday(&replayEndInputRead, NULL);
									replay_input_read_time = (double) ((replayEndInputRead.tv_sec * 1000000 + replayEndInputRead.tv_usec) - (replayStartInputRead.tv_sec * 1000000 + replayStartInputRead.tv_usec)) / 1000000;
									if(verbosity > 0){
										printf("The input set of the experimental section is read.\n");
										printf("The replay_input_read_time took %.6lf seconds.\n", replay_input_read_time);
									}
									#endif //Experimental

									gettimeofday(&startexp, NULL);
									//******************START of Experimental Section******************

                                    double qq[10];
                                    #pragma omp parallel default(shared) private(k, kk, t1, t2, t3, t4, i, ik, x1, x2, l, x, qq)
                                    {
                                        for (i = 0; i < 10; i++)
                                        {
                                            qq[i] = 0.0;
                                        }
                                        #pragma omp for reduction(+: sx, sy) nowait
                                        for (k = 1; k <= np; k++)
                                        {
                                            kk = k_offset + k;
                                            t1 = 2.71828183E8;
                                            t2 = an;
                                            for (i = 1; i <= 100; i++)
                                            {
                                                ik = kk / 2;
                                                if ((2 * ik) != kk)
                                                    t3 = randlc(&t1, t2);
                                                if (ik == 0)
                                                    break;
                                                t3 = randlc(&t2, t2);
                                                kk = ik;
                                            }

                                            if (timers_enabled)
                                                timer_start(2);
                                            vranlc(2 * (1 << 16), &t1, 1.220703125E9, x);
                                            if (timers_enabled)
                                                timer_stop(2);
                                            if (timers_enabled)
                                                timer_start(1);

                                            for (i = 0; i < (1 << 16); i++)
                                            {
                                                x1 = 2.0 * x[2 * i] - 1.0;
                                                x2 = 2.0 * x[2 * i + 1] - 1.0;
                                                t1 = x1 * x1 + x2 * x2;
                                                if (t1 <= 1.0)
                                                {
                                                    t2 = sqrt(-2.0 * log(t1) / t1);
                                                    t3 = (x1 * t2);
                                                    t4 = (x2 * t2);
                                                    // l     = MAX(fabs(t3), fabs(t4));
                                                    l = ((fabs(t3) > fabs(t4)) ? fabs(t3) : fabs(t4));
                                                    qq[l] = qq[l] + 1.0;
                                                    sx = sx + t3;
                                                    sy = sy + t4;
                                                }
                                            }

                                            if (timers_enabled)
                                                timer_stop(1);
                                        }

                                        for (i = 0; i < 10; i++)
                                        {
                                        #pragma omp atomic
                                            q[i] += qq[i];
                                        }
                                    }
									#pragma experimental section stop Out=double:q:10,double:sx,double:sy,
									//****************** END of Experimental Section ******************
									gettimeofday(&endexp, NULL);
									exp_time_used = (double) ((endexp.tv_sec * 1000000 + endexp.tv_usec) - (startexp.tv_sec * 1000000 + startexp.tv_usec)) / 1000000;
									#ifdef Initial
									if (iteration_count==iterationNum) {
										saved_exp_time_used=exp_time_used;
										FILE* initialExperimentalSectionRunTime= fopen("initialExperimentalSectionRunTime","w");
										write_var_to_file("exp_time_used", &exp_time_used, sizeof(double), 1, initialExperimentalSectionRunTime);
									if(verbosity > 0) {printf("The original experimental code section took %.6lf seconds to run.\n", exp_time_used);}
										gettimeofday(&captureStartOutputWrite, NULL);
										initialOutputStateFile = fopen("initialOutputStateFile","wb");
										write_var_to_file("q",q, sizeof(double), 10,initialOutputStateFile );
										write_var_to_file("sx",&sx, sizeof(double), 1,initialOutputStateFile );
										write_var_to_file("sy",&sy, sizeof(double), 1,initialOutputStateFile );
										gettimeofday(&captureEndOutputWrite, NULL);
										capture_output_write_time = (double) ((captureEndOutputWrite.tv_sec * 1000000 + captureEndOutputWrite.tv_usec) - (captureStartOutputWrite.tv_sec * 1000000 + captureStartOutputWrite.tv_usec)) / 1000000;
										if(verbosity > 0){
											printf("The output set of iteration %d is written to the file.\n",iteration_count);
											printf("The capture_output_write_time took %.6lf seconds.\n\n", capture_output_write_time);
										}
									}else{if(verbosity > 0){printf("The output set of iteration %d is not written to the file.\n",iteration_count);}}
										iteration_count++;
										#endif //Initial
										#ifdef Experimental
										printf("\nComparing the execution time of the experimental section before and after modification:\n");
										printf("The modified experimental section took %.6lf seconds to run.\n", exp_time_used);
										FILE* initialExperimentalSectionRunTime = fopen("initialExperimentalSectionRunTime", "r");
										read_var_from_file("initial_exp_time_used",&initial_exp_time_used, sizeof(double), 1, initialExperimentalSectionRunTime);
										printf("The original experimental section (before modifications) took %.6lf seconds to run.\n", initial_exp_time_used);
										if(closeEnough(initial_exp_time_used, exp_time_used)){
											printf("%sThe execution time of the experimental section before and after modification remains the same.%s\n",GRN,RESET);
										}else{
										printf("%sThere is a change of %.6lf seconds between the execution time of the experimental section before and after the modification%s\n",MAG, fabs((initial_exp_time_used) - (exp_time_used)), RESET);}
										FILE* modifiedExperimentalSectionTimeFile = fopen("modifiedExperimentalSectionRunTime", "w");
										fwrite(&exp_time_used, sizeof(double), 1, modifiedExperimentalSectionTimeFile);
										gettimeofday(&replayStartOutputWriteCompare, NULL);
										modifiedOutputStateFile = fopen("modifiedOutputStateFile","wb");
										write_var_to_file("q",q, sizeof(double), 10,modifiedOutputStateFile );
										write_var_to_file("sx",&sx, sizeof(double), 1,modifiedOutputStateFile );
										write_var_to_file("sy",&sy, sizeof(double), 1,modifiedOutputStateFile );

										if(verbosity > 0){
											printf("\n\nValues of output variables before modification:\n");
											initialOutputStateFile= fopen("initialOutputStateFile","rb");
											read_var_from_file("q",q, sizeof(double),10,initialOutputStateFile );
											for(int loop = 0; loop <10; loop++)
											  		printf("q[%d]=%.6lf\t", loop,q[loop]);
											printf("\n\n");
											read_var_from_file("sx",&sx, sizeof(double), 1,initialOutputStateFile );
											printf("sx=%.6lf \n",sx);
											read_var_from_file("sy",&sy, sizeof(double), 1,initialOutputStateFile );
											printf("sy=%.6lf \n",sy);
											printf("\n\nValues of output variables after modification:\n");
											fseek(modifiedOutputStateFile, 0, SEEK_SET);
											modifiedOutputStateFile= fopen("modifiedOutputStateFile","rb");
											read_var_from_file("q",q, sizeof(double),10,modifiedOutputStateFile );
											for(int loop = 0; loop <10; loop++)
											  		printf("q[%d]=%.6lf\t", loop,q[loop]);
											printf("\n\n");
											read_var_from_file("sx",&sx, sizeof(double), 1,modifiedOutputStateFile );
											printf("sx=%.6lf \n",sx);
											read_var_from_file("sy",&sy, sizeof(double), 1,modifiedOutputStateFile );
											printf("sy=%.6lf \n",sy);
										}//end of if
										printf("\n\nComparing the output variables of the experimental section before and after modification:\n");
										fseek(modifiedOutputStateFile, 0, SEEK_SET);
										compare_two_double_variables_in_binary_files("initialOutputStateFile","modifiedOutputStateFile","q", sizeof(double), 10, "double",0);
										compare_two_double_variables_in_binary_files("initialOutputStateFile","modifiedOutputStateFile","sx", sizeof(double), 1, "double",0+(10*sizeof(double)));
										compare_two_double_variables_in_binary_files("initialOutputStateFile","modifiedOutputStateFile","sy", sizeof(double), 1, "double",0+(10*sizeof(double))+sizeof(double));

										gettimeofday(&replayEndOutputWriteCompare, NULL);
										replay_output_write_time = (double) ((replayEndOutputWriteCompare.tv_sec * 1000000 + replayEndOutputWriteCompare.tv_usec) - (replayStartOutputWriteCompare.tv_sec * 1000000 + replayStartOutputWriteCompare.tv_usec)) / 1000000;
										if(verbosity > 0){
											printf("\nThe output set of the experimental section is recorded and compared.\n");
											printf("The replay_output_write_time took %.6lf seconds.\n\n", replay_output_write_time);
										}
										gettimeofday(&prgend, NULL);
										prg_time_used = (double) ((prgend.tv_sec * 1000000 + prgend.tv_usec) - (prgstart.tv_sec * 1000000 + prgstart.tv_usec)) / 1000000;
										printf("\nExecution time of the experimental section in the Replaying Phase: %.6lf (seconds) \n", prg_time_used);
										printf("Overhead of the Replaying Phase is: %.6lf (seconds) \n", prg_time_used-exp_time_used);
										printf("Execution time of the (modified) experimental section: %.6lf (seconds) \n", exp_time_used);
										_ret_val_0=0;
										return _ret_val_0;
									}
									//****************** Added for the sake of compilation only******************

									#endif //Experimental
									#ifdef Initial


									#pragma loop name main#4

									#pragma omp parallel for private(i) reduction(+: gc)
									for (i=0; i<10; i ++ )
									{
										gc=(gc+q[i]);
									}
									timer_stop(0);
									tm=timer_read(0);
									nit=0;
									verified=true;
									sx_verify_value=40338.15542441498;
									sy_verify_value=( - 26606.69192809235);
									if (verified)
									{
										sx_err=fabs((sx-sx_verify_value)/sx_verify_value);
										sy_err=fabs((sy-sy_verify_value)/sy_verify_value);
										verified=((sx_err<=1.0E-8)&&(sy_err<=1.0E-8));
									}
									Mops=((pow(2.0, 30+1)/tm)/1000000.0);
									printf("\nEP Benchmark Results:\n\n");
									printf("CPU Time =%10.4lf\n", tm);
									printf("N = 2^%5d\n", 30);
									printf("No. Gaussian Pairs = %15.0lf\n", gc);
									printf("Sums = %25.15lE %25.15lE\n", sx, sy);
									printf("Counts: \n");
									#pragma loop name main#5

									for (i=0; i<10; i ++ )
									{
										printf("%3d%15.0lf\n", i, q[i]);
									}
									print_results("EP", 'B', 30+1, 0, 0, nit, tm, Mops, "Random numbers generated", verified, "3.3.1", "05 Nov 2022", "gcc", "$(CC)", "-lm", "-I../common", "-g -Wall -O3 -mcmodel=medium", "-O3 -mcmodel=medium", "randdp");
									if (timers_enabled)
									{
										if (tm<=0.0)
										{
											tm=1.0;
										}
										tt=timer_read(0);
										printf("\nTotal time:     %9.3lf (%6.2lf)\n", tt, (tt*100.0)/tm);
										tt=timer_read(1);
										printf("Gaussian pairs: %9.3lf (%6.2lf)\n", tt, (tt*100.0)/tm);
										tt=timer_read(2);
										printf("Random numbers: %9.3lf (%6.2lf)\n", tt, (tt*100.0)/tm);
									}
									_ret_val_0=0;
									gettimeofday(&prgend, NULL);
									prg_time_used = (double) ((prgend.tv_sec * 1000000 + prgend.tv_usec) - (prgstart.tv_sec * 1000000 + prgstart.tv_usec)) / 1000000;
									printf("\nExecution time of the program in the capturing phase: %.6lf (seconds) \n", prg_time_used);
									printf("Overhead of the capturing phase: %.6lf (seconds) \n", capture_input_write_time+capture_output_write_time);
									printf("Execution time of the experimental section (before modification): %.6lf (seconds) \n", saved_exp_time_used);
								if(iteration_count>1){printf("the experimental section is iterated over %d times\n",iteration_count);}
									printf("\n\n%sUncomment the line: #define Experimental, make your changes to the experimental section then compile and run the code.%s\n",MAG ,RESET );

									return _ret_val_0;
								}

								#endif //Initial

								void print_results(char * name, char class, int n1, int n2, int n3, int niter, double t, double mops, char * optype, logical verified, char * npbversion, char * compiletime, char * cs1, char * cs2, char * cs3, char * cs4, char * cs5, char * cs6, char * cs7)
								{
									char size[16];
									int j;
									printf("\n\n %s Benchmark Completed.\n", name);
									printf(" Class           =             %12c\n", class);
									if ((n2==0)&&(n3==0))
									{
										if ((name[0]=='E')&&(name[1]=='P'))
										{
											sprintf(size, "%15.0lf", pow(2.0, n1));
											j=14;
											if (size[j]=='.')
											{
												size[j]=' ';
												j -- ;
											}
											size[j+1]='\0';
											printf(" Size            =          %15s\n", size);
										}
										else
										{
											printf(" Size            =             %12d\n", n1);
										}
									}
									else
									{
										printf(" Size            =           %4dx%4dx%4d\n", n1, n2, n3);
									}
									printf(" Iterations      =             %12d\n", niter);
									printf(" Time in seconds =             %12.2lf\n", t);
									printf(" Mop/s total     =          %15.2lf\n", mops);
									printf(" Operation type  = %24s\n", optype);
									if (verified)
									{
										printf(" Verification    =             %12s\n", "SUCCESSFUL");
									}
									else
									{
										printf(" Verification    =             %12s\n", "UNSUCCESSFUL");
									}
									printf(" Version         =             %12s\n", npbversion);
									printf(" Compile date    =             %12s\n", compiletime);
									printf("\n Compile options:\n""    CC           = %s\n", cs1);
									printf("    CLINK        = %s\n", cs2);
									printf("    C_LIB        = %s\n", cs3);
									printf("    C_INC        = %s\n", cs4);
									printf("    CFLAGS       = %s\n", cs5);
									printf("    CLINKFLAGS   = %s\n", cs6);
									printf("    RAND         = %s\n", cs7);
									printf("\n--------------------------------------\n"" Please send all errors/feedbacks to:\n"" Center for Manycore Programming\n"" cmp@aces.snu.ac.kr\n"" http://aces.snu.ac.kr\n""--------------------------------------\n\n");
									return ;
								}

								double randlc(double * x, double a)
								{
									const double r23 = 1.1920928955078125E-7;
									const double r46 = r23*r23;
									const double t23 = 8388608.0;
									const double t46 = t23*t23;
									double t1, t2, t3, t4, a1, a2, x1, x2, z;
									double r;
									t1=(r23*a);
									a1=((int)t1);
									a2=(a-(t23*a1));
									t1=(r23*( * x));
									x1=((int)t1);
									x2=(( * x)-(t23*x1));
									t1=((a1*x2)+(a2*x1));
									t2=((int)(r23*t1));
									z=(t1-(t23*t2));
									t3=((t23*z)+(a2*x2));
									t4=((int)(r46*t3));
									( * x)=(t3-(t46*t4));
									r=(r46*( * x));
									return r;
								}

								void vranlc(int n, double * x, double a, double y[])
								{
									const double r23 = 1.1920928955078125E-7;
									const double r46 = r23*r23;
									const double t23 = 8388608.0;
									const double t46 = t23*t23;
									double t1, t2, t3, t4, a1, a2, x1, x2, z;
									int i;
									t1=(r23*a);
									a1=((int)t1);
									a2=(a-(t23*a1));
									#pragma loop name vranlc#0

									for (i=0; i<n; i ++ )
									{
										t1=(r23*( * x));
										x1=((int)t1);
										x2=(( * x)-(t23*x1));
										t1=((a1*x2)+(a2*x1));
										t2=((int)(r23*t1));
										z=(t1-(t23*t2));
										t3=((t23*z)+(a2*x2));
										t4=((int)(r46*t3));
										( * x)=(t3-(t46*t4));
										y[i]=(r46*( * x));
									}
									return ;
								}

								static double elapsed_time(void )
								{
									double t;
									wtime_( & t);
									return t;
								}

								static double start[64], elapsed[64];
								void timer_clear(int n)
								{
									elapsed[n]=0.0;
									return ;
								}

								void timer_start(int n)
								{
									start[n]=elapsed_time();
									return ;
								}

								void timer_stop(int n)
								{
									double t, now;
									now=elapsed_time();
									t=(now-start[n]);
									elapsed[n]+=t;
									return ;
								}

								double timer_read(int n)
								{
									double _ret_val_0;
									_ret_val_0=elapsed[n];
									return _ret_val_0;
								}

								void wtime_(double * t)
								{
									static int sec =  - 1;
									struct timeval tv;
									gettimeofday( & tv, (void * )0);
									if (sec<0)
									{
										sec=tv.tv_sec;
									}
									( * t)=((tv.tv_sec-sec)+(1.0E-6*tv.tv_usec));
									return ;
								}
